/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem;

import java.io.Serializable;
import java.nio.file.Path;
import java.text.Normalizer;
import java.time.Duration;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.StringOps$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import zeenea.connector.ConnectorConfigurationException;
import zeenea.connector.commons.cache.ZeeCacheConfig;
import zeenea.connector.filesystem.FilePath;
import zeenea.connector.filesystem.FileSystemCommonConfiguration$;
import zeenea.connector.filesystem.FileSystemInventoryConfig;
import zeenea.connector.filesystem.inventory.InventoryLimits;
import zeenea.connector.filesystem.inventory.InventoryLimits$;
import zeenea.connector.filesystem.inventory.InventoryPatterns;
import zeenea.connector.filesystem.inventory.InventoryPatterns$;
import zeenea.connector.libs.scala.Extensions;
import zeenea.connector.libs.scala.Extensions$;
import zeenea.connector.source.PropertyValues;
import zeenea.connector.source.SourceNumberProperty;
import zeenea.connector.source.SourceProperty;
import zeenea.connector.source.SourceStringProperty;

public final class FileSystemInventoryConfig$
implements Serializable {
    public static final FileSystemInventoryConfig$ MODULE$ = new FileSystemInventoryConfig$();
    private static final Pattern forbiddenCharacters = Pattern.compile("[\\s<>:\"/\\\\|?*]+");
    private static final Pattern diacriticalMarks = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");

    private Pattern forbiddenCharacters() {
        return forbiddenCharacters;
    }

    private Pattern diacriticalMarks() {
        return diacriticalMarks;
    }

    public Try<FileSystemInventoryConfig> from(String connectionCode, PropertyValues configuration, Vector<FilePath> roots) {
        return InventoryPatterns$.MODULE$.from(configuration).flatMap((Function1 & Serializable)discoveryPattern -> Extensions.OptionTryExtension$.MODULE$.sequence$extension(Extensions$.MODULE$.OptionTryExtension(configuration.apply((SourceStringProperty)FileSystemCommonConfiguration$.MODULE$.cacheDirectAllocationConf()).map((Function1 & Serializable)v -> Extensions.TryExtension$.MODULE$.mapFailure$extension(Extensions$.MODULE$.TryExtension(Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(v)))), (Function1 & Serializable)x$1 -> new ConnectorConfigurationException((SourceProperty)FileSystemCommonConfiguration$.MODULE$.cacheDirectAllocationConf(), new StringBuilder(17).append("Invalid boolean: ").append((String)v).toString()))))).map((Function1 & Serializable)directAllocation -> {
            InventoryLimits limits = InventoryLimits$.MODULE$.from(configuration);
            return new Tuple2(directAllocation, (Object)limits);
        }).map((Function1 & Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 != null) {
                Option directAllocation = (Option)tuple2._1();
                InventoryLimits limits = (InventoryLimits)tuple2._2();
                ZeeCacheConfig.Builder cacheConfig = ZeeCacheConfig.builder();
                configuration.apply((SourceStringProperty)FileSystemCommonConfiguration$.MODULE$.cachePathConf()).map((Function1 & Serializable)p -> Path.of(p, new String[0])).orElse((Function0 & Serializable)() -> configuration.apply((SourceStringProperty)FileSystemCommonConfiguration$.MODULE$.cacheFolderConf()).map((Function1 & Serializable)f -> Path.of(f, new String[0]).resolve(MODULE$.cacheName(connectionCode)))).foreach((Function1 & Serializable)path -> cacheConfig.path(path));
                cacheConfig.timeToLive((Duration)configuration.apply((SourceStringProperty)FileSystemCommonConfiguration$.MODULE$.cacheTtlConf()).map((Function1 & Serializable)x$1 -> Duration.parse(x$1)).getOrElse((Function0 & Serializable)() -> Duration.ZERO));
                configuration.apply((SourceNumberProperty)FileSystemCommonConfiguration$.MODULE$.cacheMemPageCountConf()).foreach((Function1 & Serializable)num -> cacheConfig.memPageCount(BoxesRunTime.unboxToInt((Object)num)));
                directAllocation.foreach((Function1 & Serializable)v -> cacheConfig.directAllocation(BoxesRunTime.unboxToBoolean((Object)v)));
                return new FileSystemInventoryConfig(roots, (InventoryPatterns)discoveryPattern, limits, cacheConfig.build());
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    public Vector<FilePath> from$default$3() {
        return package$.MODULE$.Vector().empty();
    }

    private String cacheName(String connectionCode) {
        String noForbidden = this.forbiddenCharacters().matcher(connectionCode).replaceAll("_");
        String nfd = Normalizer.normalize(noForbidden, Normalizer.Form.NFD);
        String cacheName = this.diacriticalMarks().matcher(nfd).replaceAll("");
        return new StringBuilder(6).append(cacheName).append(".cache").toString();
    }

    public FileSystemInventoryConfig apply(Vector<FilePath> roots, InventoryPatterns patterns, InventoryLimits limits, ZeeCacheConfig cacheConfig) {
        return new FileSystemInventoryConfig(roots, patterns, limits, cacheConfig);
    }

    public Option<Tuple4<Vector<FilePath>, InventoryPatterns, InventoryLimits, ZeeCacheConfig>> unapply(FileSystemInventoryConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4(x$0.roots(), (Object)x$0.patterns(), (Object)x$0.limits(), (Object)x$0.cacheConfig()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileSystemInventoryConfig$.class);
    }

    private FileSystemInventoryConfig$() {
    }
}

