/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.filesystem;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.Future;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;
import scala.util.control.NonFatal$;
import zeenea.connector.commons.cache.ZeeCacheConfig;
import zeenea.connector.filesystem.CloseableIterator;
import zeenea.connector.filesystem.FilePath;
import zeenea.connector.filesystem.FilePath$;
import zeenea.connector.filesystem.FileSystemAccessDeniedException;
import zeenea.connector.filesystem.FileSystemAuthenticationException;
import zeenea.connector.filesystem.FileSystemClient;
import zeenea.connector.filesystem.FileSystemConnector$;
import zeenea.connector.filesystem.FileSystemDirectory;
import zeenea.connector.filesystem.FileSystemHierarchy;
import zeenea.connector.filesystem.FileSystemHierarchy$;
import zeenea.connector.filesystem.FileSystemInventoryConfig;
import zeenea.connector.filesystem.FileSystemItem;
import zeenea.connector.filesystem.FileSystemKind;
import zeenea.connector.filesystem.FileSystemNotFoundException;
import zeenea.connector.filesystem.FileTreeBuilder;
import zeenea.connector.filesystem.ItemDescription;
import zeenea.connector.filesystem.TracingContext;
import zeenea.connector.filesystem.TracingContext$;
import zeenea.connector.filesystem.filter.FileSystemFilter;
import zeenea.connector.filesystem.inventory.DatasetRef;
import zeenea.connector.filesystem.inventory.DatasetRef$;
import zeenea.connector.filesystem.inventory.InventoryIterator;
import zeenea.connector.filesystem.inventory.InventoryStrategy;
import zeenea.connector.filesystem.inventory.InventoryStrategy$Legacy$;
import zeenea.connector.filesystem.inventory.InventoryStrategy$Standard$;
import zeenea.connector.filesystem.inventory.InventoryWalker;
import zeenea.connector.filesystem.inventory.LegacyInventoryWalker;
import zeenea.connector.filesystem.inventory.StandardInventoryWalker;
import zeenea.connector.filesystem.schema.FileSchema;
import zeenea.connector.filesystem.schema.FormatDetector;
import zeenea.connector.filesystem.schema.NoSchemaFound;
import zeenea.connector.filesystem.schema.StandardSchemaReader;
import zeenea.connector.libs.scala.Extensions;
import zeenea.connector.libs.scala.Extensions$;
import zeenea.connector.property.StandardTechnicalMetadata$;
import zeenea.connector.source.PropertyValues;
import zeenea.connector.source.PropertyValues$;
import zeenea.connector.source.SourceDataset;
import zeenea.connector.source.SourceDataset$;
import zeenea.connector.source.SourceField;
import zeenea.connector.source.SourceItem;
import zeenea.connector.source.SourceItemContext;
import zeenea.connector.source.SourceItemName;
import zeenea.connector.source.SourceItemName$;
import zeenea.connector.source.SourcePath;
import zeenea.connector.source.SourceStringPropertyValue$;
import zeenea.connector.source.ZeePath;
import zeenea.connector.spi.AsyncExtractSource;
import zeenea.connector.spi.DatasetCollect;
import zeenea.connector.spi.DatastorageConnector;
import zeenea.connector.spi.ExtractSource;
import zeenea.connector.spi.Inventory;

@ScalaSignature(bytes="\u0006\u0005\t\u001db\u0001B\u0010!\u0005\u001dB\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005w!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003C\u0011!\u0001\u0006A!b\u0001\n\u0003\t\u0006\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011Y\u0003!Q1A\u0005\u0002]C\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\t=\u0002\u0011)\u0019!C\u0001?\"A1\r\u0001B\u0001B\u0003%\u0001\rC\u0003e\u0001\u0011\u0005Q\rC\u0004m\u0001\t\u0007I\u0011B7\t\rY\u0004\u0001\u0015!\u0003o\u0011\u001d9\b\u00011A\u0005\naD\u0011\"!\u0001\u0001\u0001\u0004%I!a\u0001\t\u000f\u0005=\u0001\u0001)Q\u0005s\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u00037\u0002A\u0011BA/\u0011\u001d\ti\u0007\u0001C\u0005\u0003_Bq!!%\u0001\t\u0013\t\u0019\nC\u0004\u00020\u0002!I!!-\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\"9\u00111\u001e\u0001\u0005\n\u00055\bb\u0002B\u0003\u0001\u0011%!q\u0001\u0005\b\u0005\u0013\u0001A\u0011\tB\u0004\u000f\u001d\u0011Y\u0001\tE\u0001\u0005\u001b1aa\b\u0011\t\u0002\t=\u0001B\u00023\u001d\t\u0003\u00119\u0002C\u0004\u0003\u001aq!\tAa\u0007\u0003'\u0019KG.Z*zgR,WnQ8o]\u0016\u001cGo\u001c:\u000b\u0005\u0005\u0012\u0013A\u00034jY\u0016\u001c\u0018p\u001d;f[*\u00111\u0005J\u0001\nG>tg.Z2u_JT\u0011!J\u0001\u0007u\u0016,g.Z1\u0004\u0001M!\u0001\u0001\u000b\u00197!\tIc&D\u0001+\u0015\tYC&\u0001\u0003mC:<'\"A\u0017\u0002\t)\fg/Y\u0005\u0003_)\u0012aa\u00142kK\u000e$\bCA\u00195\u001b\u0005\u0011$BA\u001a#\u0003\r\u0019\b/[\u0005\u0003kI\u0012A\u0003R1uCN$xN]1hK\u000e{gN\\3di>\u0014\bCA\u00198\u0013\tA$G\u0001\bECR\f7/\u001a;D_2dWm\u0019;\u0002\t-Lg\u000eZ\u000b\u0002wA\u0011A(P\u0007\u0002A%\u0011a\b\t\u0002\u000f\r&dWmU=ti\u0016l7*\u001b8e\u0003\u0015Y\u0017N\u001c3!\u00039\u0019wN\u001c8fGRLwN\\\"pI\u0016,\u0012A\u0011\t\u0003\u00072s!\u0001\u0012&\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d3\u0013A\u0002\u001fs_>$hHC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005*\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&I\u0003=\u0019wN\u001c8fGRLwN\\\"pI\u0016\u0004\u0013aD5om\u0016tGo\u001c:z\u0007>tg-[4\u0016\u0003I\u0003\"\u0001P*\n\u0005Q\u0003#!\u0007$jY\u0016\u001c\u0016p\u001d;f[&sg/\u001a8u_JL8i\u001c8gS\u001e\f\u0001#\u001b8wK:$xN]=D_:4\u0017n\u001a\u0011\u0002\r\u0019LG\u000e^3s+\u0005A\u0006CA-\\\u001b\u0005Q&B\u0001,!\u0013\ta&L\u0001\tGS2,7+_:uK64\u0015\u000e\u001c;fe\u00069a-\u001b7uKJ\u0004\u0013\u0001\u00034t\u00072LWM\u001c;\u0016\u0003\u0001\u0004\"\u0001P1\n\u0005\t\u0004#\u0001\u0005$jY\u0016\u001c\u0016p\u001d;f[\u000ec\u0017.\u001a8u\u0003%17o\u00117jK:$\b%\u0001\u0004=S:LGO\u0010\u000b\u0007M\u001eD\u0017N[6\u0011\u0005q\u0002\u0001\"B\u001d\f\u0001\u0004Y\u0004\"\u0002!\f\u0001\u0004\u0011\u0005\"\u0002)\f\u0001\u0004\u0011\u0006\"\u0002,\f\u0001\u0004A\u0006\"\u00020\f\u0001\u0004\u0001\u0017A\u00027pO\u001e,'/F\u0001o!\tyG/D\u0001q\u0015\t\t(/A\u0003tY\u001a$$NC\u0001t\u0003\ry'oZ\u0005\u0003kB\u0014a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u000fQ&,'/\u0019:dQf\u001c\u0015m\u00195f+\u0005I\bc\u0001>|{6\t\u0001*\u0003\u0002}\u0011\n1q\n\u001d;j_:\u0004\"\u0001\u0010@\n\u0005}\u0004#a\u0005$jY\u0016\u001c\u0016p\u001d;f[\"KWM]1sG\"L\u0018A\u00055jKJ\f'o\u00195z\u0007\u0006\u001c\u0007.Z0%KF$B!!\u0002\u0002\fA\u0019!0a\u0002\n\u0007\u0005%\u0001J\u0001\u0003V]&$\b\u0002CA\u0007\u001f\u0005\u0005\t\u0019A=\u0002\u0007a$\u0013'A\biS\u0016\u0014\u0018M]2is\u000e\u000b7\r[3!\u0003%IgN^3oi>\u0014\u0018\u0010\u0006\u0002\u0002\u0016A1\u0011qCA\u000f\u0003Ci!!!\u0007\u000b\u0007\u0005m\u0001*\u0001\u0003vi&d\u0017\u0002BA\u0010\u00033\u00111\u0001\u0016:z!\u0019\t\u0019#!\f\u000249!\u0011QEA\u0015\u001d\r)\u0015qE\u0005\u0002\u0013&\u0019\u00111\u0006%\u0002\u000fA\f7m[1hK&!\u0011qFA\u0019\u0005!IE/\u001a:bi>\u0014(bAA\u0016\u0011B!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:\t\naa]8ve\u000e,\u0017\u0002BA\u001f\u0003o\u0011!bU8ve\u000e,\u0007+\u0019;i\u00031)\u0007\u0010\u001e:bGRLE/Z7t)\u0011\t\u0019%!\u0015\u0011\r\u0005]\u0011QDA#!\u0019\t\u0019#a\u0012\u0002L%!\u0011\u0011JA\u0019\u0005!IE/\u001a:bE2,\u0007\u0003BA\u001b\u0003\u001bJA!a\u0014\u00028\tQ1k\\;sG\u0016LE/Z7\t\u000f\u0005M#\u00031\u0001\u0002V\u00059!0Z3qCRD\u0007\u0003BA\u001b\u0003/JA!!\u0017\u00028\t9!,Z3QCRD\u0017a\u00034s_6TV-\u001a)bi\"$B!a\u0018\u0002lA1\u0011qCA\u000f\u0003C\u0002B!a\u0019\u0002h5\u0011\u0011Q\r\u0006\u0004\u0003#\u0001\u0013\u0002BA5\u0003K\u0012!\u0002R1uCN,GOU3g\u0011\u001d\t\u0019f\u0005a\u0001\u0003+\n!B]3bIN\u001b\u0007.Z7b)!\t\t(a \u0002\u0004\u00065\u0005CBA\f\u0003;\t\u0019\b\u0005\u0003\u0002v\u0005mTBAA<\u0015\r\tI\bI\u0001\u0007g\u000eDW-\\1\n\t\u0005u\u0014q\u000f\u0002\u000b\r&dWmU2iK6\f\u0007bBAA)\u0001\u0007\u0011\u0011M\u0001\u000bI\u0006$\u0018m]3u%\u00164\u0007bBAC)\u0001\u0007\u0011qQ\u0001\u0007MNLE/Z7\u0011\u0007q\nI)C\u0002\u0002\f\u0002\u0012aBR5mKNK8\u000f^3n\u0013R,W\u000e\u0003\u0004\u0002\u0010R\u0001\r!`\u0001\nQ&,'/\u0019:dQf\fQC]3n_Z,G)\u001e9mS\u000e\fG/\u001a3GS\u0016dG\r\u0006\u0004\u0002\u0016\u0006\u0005\u00161\u0016\t\u0007\u0003G\t9*a'\n\t\u0005e\u0015\u0011\u0007\u0002\u0004'\u0016\f\b\u0003BA\u001b\u0003;KA!a(\u00028\tY1k\\;sG\u00164\u0015.\u001a7e\u0011\u001d\t\u0019+\u0006a\u0001\u0003K\u000b1a\u0019;y!\ra\u0014qU\u0005\u0004\u0003S\u0003#A\u0004+sC\u000eLgnZ\"p]R,\u0007\u0010\u001e\u0005\b\u0003[+\u0002\u0019AA:\u0003)1\u0017\u000e\\3TG\",W.Y\u0001\u0011aJ,\u0007/\u0019:f\u0011&,'/\u0019:dQf$\u0002\"a-\u00026\u0006]\u0016\u0011\u0019\t\u0006\u0003/\ti\" \u0005\b\u0003G3\u0002\u0019AAS\u0011\u001d\tIL\u0006a\u0001\u0003w\u000bAA]8piB\u0019A(!0\n\u0007\u0005}\u0006E\u0001\u0005GS2,\u0007+\u0019;i\u0011\u001d\t\u0019M\u0006a\u0001\u0003\u000b\f!b\u00197fCJ\u001c\u0015m\u00195f!\rQ\u0018qY\u0005\u0004\u0003\u0013D%a\u0002\"p_2,\u0017M\u001c\u0015\u0004-\u00055\u0007\u0003BAh\u0003+l!!!5\u000b\u0007\u0005M\u0007*\u0001\u0006b]:|G/\u0019;j_:LA!a6\u0002R\n9A/Y5me\u0016\u001c\u0017A\u00047pC\u00124\u0015\u000e\\3TsN$X-\u001c\u000b\t\u0003\u000b\ti.a8\u0002b\"9\u00111U\fA\u0002\u0005\u0015\u0006bBA]/\u0001\u0007\u00111\u0018\u0005\b\u0003G<\u0002\u0019AAs\u0003-!(/Z3Ck&dG-\u001a:\u0011\u0007q\n9/C\u0002\u0002j\u0002\u0012qBR5mKR\u0013X-\u001a\"vS2$WM]\u0001\fY><G)\u001e:bi&|g\u000e\u0006\u0004\u0002p\u0006u(\u0011\u0001\u000b\u0005\u0003c\f\u0019\u0010\u0005\u0004\u0002\u0018\u0005u\u0011Q\u0001\u0005\t\u0003kDB\u00111\u0001\u0002x\u0006Iq\u000e]3sCRLwN\u001c\t\u0006u\u0006e\u0018\u0011_\u0005\u0004\u0003wD%\u0001\u0003\u001fcs:\fW.\u001a \t\r\u0005}\b\u00041\u0001C\u00035y\u0007/\u001a:bi&|gNT1nK\"1!1\u0001\rA\u0002\t\u000b!\u0002]1sC6,G/\u001a:t\u0003)\u0019Gn\\:f\u0007\u0006\u001c\u0007.\u001a\u000b\u0003\u0003\u000b\tQa\u00197pg\u0016\f1CR5mKNK8\u000f^3n\u0007>tg.Z2u_J\u0004\"\u0001\u0010\u000f\u0014\u0007q\u0011\t\u0002E\u0002{\u0005'I1A!\u0006I\u0005\u0019\te.\u001f*fMR\u0011!QB\u0001\u0006CB\u0004H.\u001f\u000b\fM\nu!q\u0004B\u0011\u0005G\u0011)\u0003C\u0003:=\u0001\u00071\bC\u0003A=\u0001\u0007!\tC\u0003Q=\u0001\u0007!\u000bC\u0003W=\u0001\u0007\u0001\fC\u0003_=\u0001\u0007\u0001\r")
public final class FileSystemConnector
implements DatasetCollect {
    private final FileSystemKind kind;
    private final String connectionCode;
    private final FileSystemInventoryConfig inventoryConfig;
    private final FileSystemFilter filter;
    private final FileSystemClient fsClient;
    private final Logger zeenea$connector$filesystem$FileSystemConnector$$logger;
    private Option<FileSystemHierarchy> hierarchyCache;

    public static FileSystemConnector apply(FileSystemKind kind, String connectionCode, FileSystemInventoryConfig inventoryConfig, FileSystemFilter filter, FileSystemClient fsClient) {
        return FileSystemConnector$.MODULE$.apply(kind, connectionCode, inventoryConfig, filter, fsClient);
    }

    public Future<Iterable<SourceItem>> futureExtractItems(ZeePath path) {
        return ExtractSource.futureExtractItems$((ExtractSource)this, (ZeePath)path);
    }

    public boolean schemaShouldBeUpdated(SourceItemContext sourceItemContext) {
        return AsyncExtractSource.schemaShouldBeUpdated$((AsyncExtractSource)this, (SourceItemContext)sourceItemContext);
    }

    public Future<Iterator<SourcePath>> futureInventory() {
        return Inventory.futureInventory$((Inventory)this);
    }

    public FileSystemKind kind() {
        return this.kind;
    }

    public String connectionCode() {
        return this.connectionCode;
    }

    public FileSystemInventoryConfig inventoryConfig() {
        return this.inventoryConfig;
    }

    public FileSystemFilter filter() {
        return this.filter;
    }

    public FileSystemClient fsClient() {
        return this.fsClient;
    }

    public Logger zeenea$connector$filesystem$FileSystemConnector$$logger() {
        return this.zeenea$connector$filesystem$FileSystemConnector$$logger;
    }

    private Option<FileSystemHierarchy> hierarchyCache() {
        return this.hierarchyCache;
    }

    private void hierarchyCache_$eq(Option<FileSystemHierarchy> x$1) {
        this.hierarchyCache = x$1;
    }

    public Try<Iterator<SourcePath>> inventory() {
        String ctx = TracingContext$.MODULE$.inventory(this.connectionCode());
        this.zeenea$connector$filesystem$FileSystemConnector$$logger().info("file_system_{}_inventory_start {}", (Object)this.kind(), (Object)new TracingContext(ctx));
        return this.prepareHierarchy(ctx, FilePath$.MODULE$.root(), true).flatMap((Function1 & Serializable)hierarchy -> hierarchy.root().flatMap((Function1 & Serializable)root -> (this.inventoryConfig().roots().isEmpty() ? Try$.MODULE$.apply((Function0 & Serializable)() -> hierarchy.listChildren((FileSystemDirectory)root)) : Try$.MODULE$.apply((Function0 & Serializable)() -> (Vector)this.inventoryConfig().roots().flatMap((Function1 & Serializable)rPath -> hierarchy.find((FilePath)rPath).toOption()))).map((Function1 & Serializable)roots -> {
            InventoryWalker inventoryWalker;
            InventoryStrategy inventoryStrategy = this.inventoryConfig().patterns().strategy();
            if (InventoryStrategy$Legacy$.MODULE$.equals(inventoryStrategy)) {
                inventoryWalker = new LegacyInventoryWalker(this.kind(), this.inventoryConfig().patterns(), (FileSystemHierarchy)hierarchy, this.fsClient(), (Vector<FileSystemItem>)roots);
            } else if (InventoryStrategy$Standard$.MODULE$.equals(inventoryStrategy)) {
                inventoryWalker = new StandardInventoryWalker(ctx, this.kind(), this.inventoryConfig().limits(), this.inventoryConfig().patterns(), (FileSystemHierarchy)hierarchy, (Vector<FileSystemItem>)roots);
            } else {
                throw new MatchError((Object)inventoryStrategy);
            }
            InventoryWalker walker = inventoryWalker;
            return new Tuple2(roots, (Object)walker);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                InventoryWalker walker = (InventoryWalker)tuple2._2();
                return new InventoryIterator(ctx, this.kind(), this.inventoryConfig().limits(), walker);
            }
            throw new MatchError((Object)tuple2);
        })));
    }

    public Try<Iterable<SourceItem>> extractItems(ZeePath zeepath) {
        String ctx = TracingContext$.MODULE$.extractItem(this.connectionCode(), zeepath);
        this.zeenea$connector$filesystem$FileSystemConnector$$logger().info("file_system_{}_extract_items_start {}", (Object)this.kind(), (Object)new TracingContext(ctx));
        return Extensions.TryExtension$.MODULE$.onSuccess$extension(Extensions$.MODULE$.TryExtension(this.fromZeePath(zeepath).flatMap((Function1 & Serializable)datasetRef -> this.prepareHierarchy(ctx, datasetRef.path(), false).flatMap((Function1 & Serializable)hierarchy -> hierarchy.find(datasetRef.path()).flatMap((Function1 & Serializable)fsItem -> this.readSchema((DatasetRef)datasetRef, (FileSystemItem)fsItem, (FileSystemHierarchy)hierarchy).map((Function1 & Serializable)fileSchema -> {
            SourceDataset[] sourceDatasetArray = new SourceDataset[1];
            SourceItemName x$1 = SourceItemName$.MODULE$.apply(datasetRef.sourceName());
            ZeePath x$2 = zeepath;
            PropertyValues x$3 = PropertyValues$.MODULE$.from((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StandardTechnicalMetadata$.MODULE$.format()), (Object)SourceStringPropertyValue$.MODULE$.apply(fileSchema.format().name()))})), PropertyValues$.MODULE$.from$default$2()).$plus$plus(this.fsClient().itemSourceProperties(ctx, (FileSystemItem)fsItem));
            Seq<SourceField> x$4 = this.removeDuplicatedField(ctx, (FileSchema)fileSchema);
            Seq x$5 = SourceDataset$.MODULE$.apply$default$5();
            Seq x$6 = SourceDataset$.MODULE$.apply$default$6();
            Seq x$7 = SourceDataset$.MODULE$.apply$default$7();
            Option x$8 = SourceDataset$.MODULE$.apply$default$8();
            Instant x$9 = SourceDataset$.MODULE$.apply$default$9();
            Option x$10 = SourceDataset$.MODULE$.apply$default$10();
            Seq x$11 = SourceDataset$.MODULE$.apply$default$11();
            sourceDatasetArray[0] = new SourceDataset(x$1, x$2, x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
            return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])sourceDatasetArray));
        }).recover((PartialFunction)new Serializable(this, (FileSystemItem)fsItem, zeepath){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemConnector $outer;
            private final FileSystemItem fsItem$1;
            private final ZeePath zeepath$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof NoSchemaFound) {
                    this.$outer.zeenea$connector$filesystem$FileSystemConnector$$logger().info("file_system_{}_extract_items_no_schema_found", (Object)this.$outer.kind());
                    return (B1)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SourceDataset[]{new SourceDataset(SourceItemName$.MODULE$.apply(this.fsItem$1.path().name()), this.zeepath$1, (Seq)Nil$.MODULE$, SourceDataset$.MODULE$.apply$default$4(), SourceDataset$.MODULE$.apply$default$5(), SourceDataset$.MODULE$.apply$default$6(), SourceDataset$.MODULE$.apply$default$7(), SourceDataset$.MODULE$.apply$default$8(), SourceDataset$.MODULE$.apply$default$9(), SourceDataset$.MODULE$.apply$default$10(), SourceDataset$.MODULE$.apply$default$11())}));
                }
                if (A1 instanceof FileSystemAuthenticationException) {
                    FileSystemAuthenticationException fileSystemAuthenticationException = (FileSystemAuthenticationException)A1;
                    if (!this.$outer.zeenea$connector$filesystem$FileSystemConnector$$logger().isDebugEnabled()) {
                        this.$outer.zeenea$connector$filesystem$FileSystemConnector$$logger().warn("file_system_{}_extract_items_authentication_failure path='{}' {}", new Object[]{this.$outer.kind(), this.zeepath$1.escapedValue(), fileSystemAuthenticationException.getMessage()});
                    } else {
                        this.$outer.zeenea$connector$filesystem$FileSystemConnector$$logger().warn("file_system_{}_extract_items_authentication_failure path='{}' {}", new Object[]{this.$outer.kind(), this.zeepath$1.escapedValue(), fileSystemAuthenticationException.getMessage(), fileSystemAuthenticationException});
                    }
                    return (B1)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SourceDataset[]{new SourceDataset(SourceItemName$.MODULE$.apply(this.fsItem$1.path().name()), this.zeepath$1, (Seq)Nil$.MODULE$, SourceDataset$.MODULE$.apply$default$4(), SourceDataset$.MODULE$.apply$default$5(), SourceDataset$.MODULE$.apply$default$6(), SourceDataset$.MODULE$.apply$default$7(), SourceDataset$.MODULE$.apply$default$8(), SourceDataset$.MODULE$.apply$default$9(), SourceDataset$.MODULE$.apply$default$10(), SourceDataset$.MODULE$.apply$default$11())}));
                }
                if (A1 instanceof FileSystemAccessDeniedException) {
                    FileSystemAccessDeniedException fileSystemAccessDeniedException = (FileSystemAccessDeniedException)A1;
                    if (!this.$outer.zeenea$connector$filesystem$FileSystemConnector$$logger().isDebugEnabled()) {
                        this.$outer.zeenea$connector$filesystem$FileSystemConnector$$logger().warn("file_system_{}_extract_items_access_denied_failure path='{}' {}", new Object[]{this.$outer.kind(), this.zeepath$1.escapedValue(), fileSystemAccessDeniedException.getMessage()});
                    } else {
                        this.$outer.zeenea$connector$filesystem$FileSystemConnector$$logger().warn("file_system_{}_extract_items_access_denied_failure path='{}' {}", new Object[]{this.$outer.kind(), this.zeepath$1.escapedValue(), fileSystemAccessDeniedException.getMessage(), fileSystemAccessDeniedException});
                    }
                    return (B1)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SourceDataset[]{new SourceDataset(SourceItemName$.MODULE$.apply(this.fsItem$1.path().name()), this.zeepath$1, (Seq)Nil$.MODULE$, SourceDataset$.MODULE$.apply$default$4(), SourceDataset$.MODULE$.apply$default$5(), SourceDataset$.MODULE$.apply$default$6(), SourceDataset$.MODULE$.apply$default$7(), SourceDataset$.MODULE$.apply$default$8(), SourceDataset$.MODULE$.apply$default$9(), SourceDataset$.MODULE$.apply$default$10(), SourceDataset$.MODULE$.apply$default$11())}));
                }
                if (NonFatal$.MODULE$.apply(A1)) {
                    this.$outer.zeenea$connector$filesystem$FileSystemConnector$$logger().error("file_system_{}_extract_items_infer_schema_failure", (Object)this.$outer.kind(), A1);
                    return (B1)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SourceDataset[]{new SourceDataset(SourceItemName$.MODULE$.apply(this.fsItem$1.path().name()), this.zeepath$1, (Seq)Nil$.MODULE$, SourceDataset$.MODULE$.apply$default$4(), SourceDataset$.MODULE$.apply$default$5(), SourceDataset$.MODULE$.apply$default$6(), SourceDataset$.MODULE$.apply$default$7(), SourceDataset$.MODULE$.apply$default$8(), SourceDataset$.MODULE$.apply$default$9(), SourceDataset$.MODULE$.apply$default$10(), SourceDataset$.MODULE$.apply$default$11())}));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof NoSchemaFound) {
                    return true;
                }
                if (throwable instanceof FileSystemAuthenticationException) {
                    return true;
                }
                if (throwable instanceof FileSystemAccessDeniedException) {
                    return true;
                }
                return NonFatal$.MODULE$.apply(throwable);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fsItem$1 = fsItem$1;
                this.zeepath$1 = zeepath$1;
            }
        }).map((Function1 & Serializable)result -> result))))), (Function1 & Serializable)items -> {
            FileSystemConnector.$anonfun$extractItems$6(this, items);
            return BoxedUnit.UNIT;
        }).recover((PartialFunction)new Serializable(this, zeepath){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemConnector $outer;
            private final ZeePath zeepath$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof FileNotFoundException) {
                    FileNotFoundException fileNotFoundException = (FileNotFoundException)A1;
                    if (!this.$outer.zeenea$connector$filesystem$FileSystemConnector$$logger().isDebugEnabled()) {
                        this.$outer.zeenea$connector$filesystem$FileSystemConnector$$logger().warn("file_system_{}_extract_items_not_found path='{}' {}", new Object[]{this.$outer.kind(), this.zeepath$1.escapedValue(), fileNotFoundException.getMessage()});
                    } else {
                        this.$outer.zeenea$connector$filesystem$FileSystemConnector$$logger().warn("file_system_{}_extract_items_not_found path='{}' {}", new Object[]{this.$outer.kind(), this.zeepath$1.escapedValue(), fileNotFoundException.getMessage(), fileNotFoundException});
                    }
                    return (B1)package$.MODULE$.Vector().empty();
                }
                this.$outer.zeenea$connector$filesystem$FileSystemConnector$$logger().error("file_system_{}_extract_items_failure path='{}'", new Object[]{this.$outer.kind(), this.zeepath$1.escapedValue(), A1});
                return (B1)package$.MODULE$.Vector().empty();
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                if (throwable instanceof FileNotFoundException) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.zeepath$1 = zeepath$1;
            }
        });
    }

    private Try<DatasetRef> fromZeePath(ZeePath zeepath) {
        InventoryStrategy inventoryStrategy = this.inventoryConfig().patterns().strategy();
        if (InventoryStrategy$Legacy$.MODULE$.equals(inventoryStrategy)) {
            return DatasetRef$.MODULE$.legacy(this.kind(), zeepath);
        }
        if (InventoryStrategy$Standard$.MODULE$.equals(inventoryStrategy)) {
            return DatasetRef$.MODULE$.standard(this.kind(), zeepath);
        }
        throw new MatchError((Object)inventoryStrategy);
    }

    private Try<FileSchema> readSchema(DatasetRef datasetRef, FileSystemItem fsItem, FileSystemHierarchy hierarchy) {
        InventoryStrategy inventoryStrategy = this.inventoryConfig().patterns().strategy();
        if (InventoryStrategy$Legacy$.MODULE$.equals(inventoryStrategy)) {
            return new FormatDetector(this.inventoryConfig().patterns(), hierarchy, this.fsClient()).retriveFileSchema(fsItem);
        }
        if (InventoryStrategy$Standard$.MODULE$.equals(inventoryStrategy)) {
            return new StandardSchemaReader(this.kind(), this.inventoryConfig().patterns(), hierarchy, this.fsClient()).readSchema(datasetRef, fsItem);
        }
        throw new MatchError((Object)inventoryStrategy);
    }

    private Seq<SourceField> removeDuplicatedField(String ctx, FileSchema fileSchema) {
        Seq<SourceField> fields = fileSchema.fields();
        Map duplicates = (Map)fields.groupMapReduce((Function1 & Serializable)x$2 -> x$2.key(), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)FileSystemConnector.$anonfun$removeDuplicatedField$2(x$3)), (Function2)(JFunction2.mcIII.sp & Serializable)(x$4, x$5) -> x$4 + x$5).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FileSystemConnector.$anonfun$removeDuplicatedField$4(x0$1)));
        if (duplicates.nonEmpty()) {
            duplicates.foreach((Function1 & Serializable)x0$2 -> {
                FileSystemConnector.$anonfun$removeDuplicatedField$5(this, ctx, fileSchema, x0$2);
                return BoxedUnit.UNIT;
            });
            return (Seq)fields.groupMapReduce((Function1 & Serializable)x$6 -> x$6.key(), (Function1 & Serializable)x -> (SourceField)Predef$.MODULE$.identity(x), (Function2 & Serializable)(a, b) -> {
                if (a.nativeIndex() <= b.nativeIndex()) {
                    return a;
                }
                return b;
            }).values().toVector().sortBy((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.nativeIndex()), (Ordering)Ordering.Int$.MODULE$);
        }
        return fields;
    }

    private Try<FileSystemHierarchy> prepareHierarchy(String ctx, FilePath root2, boolean clearCache) {
        Option<FileSystemHierarchy> option;
        while (true) {
            boolean bl = false;
            Some some = null;
            option = this.hierarchyCache();
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                FileSystemHierarchy hierarchy2 = (FileSystemHierarchy)some.value();
                FilePath filePath = hierarchy2.refPath();
                FilePath filePath2 = root2;
                if (!(filePath != null ? !((Object)filePath).equals(filePath2) : filePath2 != null)) {
                    return new Success((Object)hierarchy2);
                }
            }
            if (!bl) break;
            this.closeCache();
        }
        if (None$.MODULE$.equals(option)) {
            ZeeCacheConfig cacheConfig = this.inventoryConfig().cacheConfig();
            ZeeCacheConfig actualCacheConfig = root2.isRoot() || FileSystemConnector.longLifeCache$1(cacheConfig) ? cacheConfig : ZeeCacheConfig.memory();
            return Extensions.TryExtension$.MODULE$.onFailure$extension(Extensions$.MODULE$.TryExtension(Extensions.TryExtension$.MODULE$.onSuccess$extension(Extensions$.MODULE$.TryExtension(FileSystemHierarchy$.MODULE$.create(this.kind(), root2, actualCacheConfig, clearCache, (Function2<FilePath, FileTreeBuilder, BoxedUnit>)(Function2 & Serializable)(root, treeBuilder) -> {
                this.loadFileSystem(ctx, root, treeBuilder);
                return BoxedUnit.UNIT;
            })), (Function1 & Serializable)hierarchy -> {
                this.hierarchyCache_$eq((Option<FileSystemHierarchy>)new Some((Object)hierarchy));
                return BoxedUnit.UNIT;
            })), (Function1 & Serializable)e -> {
                FileSystemConnector.$anonfun$prepareHierarchy$4(this, ctx, e);
                return BoxedUnit.UNIT;
            });
        }
        throw new MatchError(option);
    }

    private void loadFileSystem(String ctx, FilePath root, FileTreeBuilder treeBuilder) {
        this.logDuration("load_file_system", new StringBuilder(7).append("root='").append(root).append("'").toString(), (Function0<Try<BoxedUnit>>)(Function0 & Serializable)() -> (root.isRoot() ? (this.inventoryConfig().roots().isEmpty() ? this.fsClient().listRoots() : new Success(this.inventoryConfig().roots().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())))) : new Success(package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FilePath[]{root})))).flatMap((Function1 & Serializable)roots -> Extensions.TraversableOnceTryExtension$.MODULE$.sequence$extension(Extensions$.MODULE$.TraversableOnceTryExtension((IterableOnce)roots.map((Function1 & Serializable)r -> this.logDuration("load_tree", new StringBuilder(7).append("root='").append(r).append("'").toString(), (Function0<Try<BoxedUnit>>)(Function0 & Serializable)() -> this.fsClient().listFiles(ctx, (FilePath)r).map((Function1 & Serializable)it -> {
            Using$.MODULE$.resource((Object)it, (Function1 & Serializable)it -> {
                FileSystemConnector.$anonfun$loadFileSystem$6($this, treeBuilder$1, it);
                return BoxedUnit.UNIT;
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            return BoxedUnit.UNIT;
        })))), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)x$8 -> {
            vector = x$8;
            return BoxedUnit.UNIT;
        }))).get();
    }

    private Try<BoxedUnit> logDuration(String operationName, String parameters, Function0<Try<BoxedUnit>> operation) {
        Throwable err;
        Throwable err2;
        this.zeenea$connector$filesystem$FileSystemConnector$$logger().info("file_system_{}_{}_start {}", new Object[]{this.kind(), operationName, parameters});
        Instant startTime = Instant.now();
        Try result = (Try)operation.apply();
        Duration duration = Duration.between(startTime, Instant.now());
        boolean bl = false;
        Failure failure = null;
        Try try_ = result;
        if (try_ instanceof Success) {
            this.zeenea$connector$filesystem$FileSystemConnector$$logger().info("file_system_{}_{}_success {} duration='{}'", new Object[]{this.kind(), operationName, parameters, duration});
            return result;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable err3 = failure.exception();
            if (err3 instanceof FileSystemAuthenticationException) {
                FileSystemAuthenticationException fileSystemAuthenticationException = (FileSystemAuthenticationException)err3;
                String msg = fileSystemAuthenticationException.msg();
                if (this.zeenea$connector$filesystem$FileSystemConnector$$logger().isDebugEnabled()) {
                    this.zeenea$connector$filesystem$FileSystemConnector$$logger().error("file_system_{}_{}_authentication_failure {} duration='{}' {}", new Object[]{this.kind(), operationName, parameters, duration, msg, fileSystemAuthenticationException});
                } else {
                    this.zeenea$connector$filesystem$FileSystemConnector$$logger().error("file_system_{}_{}_authentication_failure {} duration='{}' {}", new Object[]{this.kind(), operationName, parameters, duration, msg});
                }
                return result;
            }
        }
        if (bl && (err2 = failure.exception()) instanceof FileSystemAccessDeniedException) {
            FileSystemAccessDeniedException fileSystemAccessDeniedException = (FileSystemAccessDeniedException)err2;
            String msg = fileSystemAccessDeniedException.msg();
            if (this.zeenea$connector$filesystem$FileSystemConnector$$logger().isDebugEnabled()) {
                this.zeenea$connector$filesystem$FileSystemConnector$$logger().warn("file_system_{}_{}_access_denied {} duration='{}' {}", new Object[]{this.kind(), operationName, parameters, duration, msg, fileSystemAccessDeniedException});
            } else {
                this.zeenea$connector$filesystem$FileSystemConnector$$logger().warn("file_system_{}_{}_access_denied {} duration='{}' {}", new Object[]{this.kind(), operationName, parameters, duration, msg});
            }
            return new Success((Object)BoxedUnit.UNIT);
        }
        if (bl && (err = failure.exception()) instanceof FileSystemNotFoundException) {
            FileSystemNotFoundException fileSystemNotFoundException = (FileSystemNotFoundException)err;
            String msg = fileSystemNotFoundException.msg();
            if (this.zeenea$connector$filesystem$FileSystemConnector$$logger().isDebugEnabled()) {
                this.zeenea$connector$filesystem$FileSystemConnector$$logger().warn("file_system_{}_{}_not_found {} duration='{}' {}", new Object[]{this.kind(), operationName, parameters, duration, msg, fileSystemNotFoundException});
            } else {
                this.zeenea$connector$filesystem$FileSystemConnector$$logger().warn("file_system_{}_{}_not_found {} duration='{}' {}", new Object[]{this.kind(), operationName, parameters, duration, msg});
            }
            return new Success((Object)BoxedUnit.UNIT);
        }
        if (bl) {
            Throwable e = failure.exception();
            this.zeenea$connector$filesystem$FileSystemConnector$$logger().error("file_system_{}_{}_failure {} duration='{}'", new Object[]{this.kind(), operationName, parameters, duration, e});
            return result;
        }
        throw new MatchError((Object)try_);
    }

    private void closeCache() {
        this.hierarchyCache().foreach((Function1 & Serializable)x$9 -> {
            x$9.close();
            return BoxedUnit.UNIT;
        });
        this.hierarchyCache_$eq((Option<FileSystemHierarchy>)None$.MODULE$);
    }

    public void close() {
        this.closeCache();
        this.fsClient().close();
    }

    public static final /* synthetic */ void $anonfun$extractItems$6(FileSystemConnector $this, Vector items) {
        $this.zeenea$connector$filesystem$FileSystemConnector$$logger().info("file_system_{}_extract_items_success items_found='{}'", (Object)$this.kind(), (Object)BoxesRunTime.boxToInteger((int)items.size()));
    }

    public static final /* synthetic */ int $anonfun$removeDuplicatedField$2(SourceField x$3) {
        return 1;
    }

    public static final /* synthetic */ boolean $anonfun$removeDuplicatedField$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int count = tuple2._2$mcI$sp();
            return count > 1;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$removeDuplicatedField$5(FileSystemConnector $this, String ctx$3, FileSchema fileSchema$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            SourceField.Key key = (SourceField.Key)tuple2._1();
            int count = tuple2._2$mcI$sp();
            $this.zeenea$connector$filesystem$FileSystemConnector$$logger().warn("file_system_{}_duplicated_columns_found {} file='{}' column_key='{}' count='{}' only the first instance will be imported", new Object[]{$this.kind(), new TracingContext(ctx$3), fileSchema$1.sampleItem().path(), key.keys().mkString("/"), BoxesRunTime.boxToInteger((int)count)});
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$prepareHierarchy$1(Duration d) {
        return !d.isNegative() && !d.isZero();
    }

    private static final boolean longLifeCache$1(ZeeCacheConfig cacheConfig$1) {
        return Option$.MODULE$.apply((Object)cacheConfig$1.path()).isDefined() && Option$.MODULE$.apply((Object)cacheConfig$1.timeToLive()).exists((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)FileSystemConnector.$anonfun$prepareHierarchy$1(d)));
    }

    public static final /* synthetic */ void $anonfun$prepareHierarchy$4(FileSystemConnector $this, String ctx$4, Throwable e) {
        $this.zeenea$connector$filesystem$FileSystemConnector$$logger().error("file_system_{}_prepare_hierarchy_failure {}", new Object[]{$this.kind(), new TracingContext(ctx$4), e});
    }

    public static final /* synthetic */ boolean $anonfun$loadFileSystem$7(FileSystemConnector $this, ItemDescription itemDesc) {
        return $this.filter().filterItem(itemDesc);
    }

    public static final /* synthetic */ void $anonfun$loadFileSystem$6(FileSystemConnector $this, FileTreeBuilder treeBuilder$1, CloseableIterator it) {
        it.filter((Function1 & Serializable)itemDesc -> BoxesRunTime.boxToBoolean((boolean)FileSystemConnector.$anonfun$loadFileSystem$7($this, itemDesc))).foreach((Function1 & Serializable)newItem -> {
            treeBuilder$1.add(newItem);
            return BoxedUnit.UNIT;
        });
    }

    public FileSystemConnector(FileSystemKind kind, String connectionCode, FileSystemInventoryConfig inventoryConfig, FileSystemFilter filter, FileSystemClient fsClient) {
        this.kind = kind;
        this.connectionCode = connectionCode;
        this.inventoryConfig = inventoryConfig;
        this.filter = filter;
        this.fsClient = fsClient;
        DatastorageConnector.$init$((DatastorageConnector)this);
        Inventory.$init$((Inventory)this);
        AsyncExtractSource.$init$((AsyncExtractSource)this);
        ExtractSource.$init$((ExtractSource)this);
        this.zeenea$connector$filesystem$FileSystemConnector$$logger = LoggerFactory.getLogger(FileSystemConnector.class);
        this.hierarchyCache = None$.MODULE$;
    }
}

