/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.core;

import java.util.HashSet;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.SpanReceiver;
import org.apache.htrace.core.Tracer;

public class TracerPool {
    static final TracerPool GLOBAL = new TracerPool("Global");
    private final String name;
    private volatile SpanReceiver[] curReceivers;
    private final HashSet<Tracer> curTracers;

    public static TracerPool getGlobalTracerPool() {
        return GLOBAL;
    }

    public TracerPool(String string) {
        this.name = string;
        this.curTracers = new HashSet();
        this.curReceivers = new SpanReceiver[0];
    }

    public String getName() {
        return this.name;
    }

    public SpanReceiver[] getReceivers() {
        return this.curReceivers;
    }

    public boolean addReceiver(SpanReceiver spanReceiver) {
        return true;
    }

    public boolean removeReceiver(SpanReceiver spanReceiver) {
        return true;
    }

    public boolean removeAndCloseReceiver(SpanReceiver spanReceiver) {
        return true;
    }

    public SpanReceiver loadReceiverType(String string, HTraceConfiguration hTraceConfiguration, ClassLoader classLoader) {
        SpanReceiver spanReceiver = new SpanReceiver.Builder(hTraceConfiguration).className(string).classLoader(classLoader).build();
        this.addReceiver(spanReceiver);
        return spanReceiver;
    }

    public synchronized Tracer[] getTracers() {
        return this.curTracers.toArray(new Tracer[this.curTracers.size()]);
    }

    synchronized void addTracer(Tracer tracer) {
    }

    synchronized void removeTracer(Tracer tracer) {
    }

    public String toString() {
        return "TracerPool(" + this.name + ")";
    }
}

