/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.nio.ByteBuffer;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.Page;

class TableDesc {
    public static final TableDesc INVALID = new TableDesc(-1, 0L);
    public static final int SIZE_INDEX = 4;
    public static final int BYTES = 12;
    private final int rootPageNumber;
    private final long size;

    private TableDesc(int rootPageNumber, long size) {
        this.rootPageNumber = rootPageNumber;
        this.size = size;
    }

    static TableDesc of(int rootPageNumber, long size) {
        return new TableDesc(rootPageNumber, size);
    }

    static TableDesc read(Page page, int index) {
        return new TableDesc(page.getInt(index), page.getLong(index + 4));
    }

    static TableDesc read(CacheData data) {
        if (data.length() != 12) {
            throw new IllegalArgumentException("Not a table desc");
        }
        ByteBuffer bb = data.toByteBuffer();
        return new TableDesc(bb.getInt(), bb.getLong());
    }

    public int rootPageNumber() {
        return this.rootPageNumber;
    }

    public long size() {
        return this.size;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocate(12);
        bb.putInt(this.rootPageNumber);
        bb.putLong(this.size);
        bb.flip();
        return bb;
    }

    CacheData toCacheData() {
        return CacheData.of(this.toByteBuffer());
    }
}

