/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.cache.BTreeLeafEntry;
import zeenea.connector.commons.cache.BTreePage;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.CacheEntry;
import zeenea.connector.commons.cache.CachePageLoader;
import zeenea.connector.commons.cache.DataEntry;
import zeenea.connector.commons.cache.Page;

final class BTreeLeafPage
extends BTreePage {
    private static final int ENTRY_COUNT_INDEX = 1;
    private static final int ENTRY_DATA_ZONE_INDEX = 3;
    private static final int ENTRY_LIST_INDEX = 5;
    private final int offset;

    BTreeLeafPage(CachePageLoader pageLoader, int pageNumber, int offset) {
        super(pageLoader, pageNumber);
        this.offset = offset;
    }

    static BTreeLeafPage of(CachePageLoader pageLoader, int pageNumber, int offset) {
        return new BTreeLeafPage(pageLoader, pageNumber, offset);
    }

    static BTreeLeafPage init(CachePageLoader pageLoader, Page page, int offset) {
        BTreeLeafPage leafPage = new BTreeLeafPage(pageLoader, page.number(), offset);
        page.put(leafPage.offset(), (byte)76);
        page.putShort(leafPage.offset() + 1, (short)0);
        page.putShort(leafPage.offset() + 3, (short)4096);
        return leafPage;
    }

    @Override
    byte code() {
        return 76;
    }

    private int offset() {
        return this.offset;
    }

    @Override
    boolean isLeaf() {
        return true;
    }

    @Override
    boolean isLast(int entryNumber) {
        return entryNumber == this.entryCount() - 1;
    }

    @Override
    int entryCount() {
        return this.applyToPageAsInt(this::entryCount);
    }

    @Override
    protected int entryCount(Page page) {
        return page.getShort(this.offset() + 1) & 0xFFFF;
    }

    @Override
    protected void setEntryCount(Page page, int value) {
        page.putShort(this.offset() + 1, (short)value);
    }

    @Override
    protected int entryDataZone(Page page) {
        return page.getShort(this.offset() + 3) & 0xFFFF;
    }

    @Override
    protected void setEntryDataZone(Page page, int value) {
        page.putShort(this.offset() + 3, (short)value);
    }

    @Override
    protected int entryPointerIndex(int entryNumber) {
        return this.offset() + 5 + entryNumber * 2;
    }

    @Override
    @NotNull
    protected CacheData key(Page page, int entryNumber) {
        this.checkEntryNumber(page, entryNumber, true);
        int entryIndex = this.entryIndex(page, entryNumber);
        return CacheData.of(this, DataEntry.of(page, entryIndex));
    }

    CacheData lastKey() {
        return this.applyToPage(page -> this.key((Page)page, this.entryCount((Page)page) - 1));
    }

    CacheData readValue(int entryNumber) {
        return this.applyToPage(page -> {
            this.checkEntryNumber((Page)page, entryNumber, true);
            int entryIndex = this.entryIndex((Page)page, entryNumber);
            BTreeLeafEntry leafEntry = BTreeLeafEntry.of(page, entryIndex);
            return CacheData.of(this, leafEntry.valueEntry());
        });
    }

    CacheEntry readEntry(int entryNumber) {
        return this.applyToPage(page -> {
            this.checkEntryNumber((Page)page, entryNumber, true);
            int entryIndex = this.entryIndex((Page)page, entryNumber);
            BTreeLeafEntry leafEntry = BTreeLeafEntry.of(page, entryIndex);
            return CacheEntry.of(this, leafEntry);
        });
    }

    int splitTo(BTreeLeafPage target) {
        return this.applyToPageAsInt(page -> {
            int pivot = this.entryCount((Page)page) / 2;
            this.copyTo((Page)page, target, pivot);
            this.compact((Page)page, pivot);
            return pivot;
        });
    }

    @Override
    BTreeLeafEntry entry(int entryNumber) {
        return this.applyToPage(page -> this.entry((Page)page, entryNumber));
    }

    @Override
    protected BTreeLeafEntry entry(Page page, int entryNumber) {
        int entryIndex = this.entryIndex(page, entryNumber);
        return BTreeLeafEntry.of(page, entryIndex);
    }

    public String toString() {
        return String.format("BTreeLeafPage %1$d (0x%1$x) with %2$d entries", this.pageNumber(), this.entryCount());
    }
}

